/******************************************************************************
 *
 * tw_extension.h - Extension for the Tivaware Driver Library for TI Tiva C
 *  microcontrollers.
 *
 *  Author: Curtis Mayberry
 *  Georgia Tech IMEMS
 *  rev1 March 2014
 *
 *  Originally written for the MRIG gyroscope project
 *
 *  This work is licensed under the Creative Commons Attribution-ShareAlike 3.0
 *  Unported License. To view a copy of this license, visit
 *  http://creativecommons.org/licenses/by-sa/3.0/ or send a letter to Creative
 *  Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 *
 ******************************************************************************/

#ifndef tw_extension_H_
#define tw_extension_H_

// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
#ifdef __cplusplus
extern "C"
{
#endif

/************
 * TypeDefs *
 ************/

/**
 * Data type for saving a float to flash memory
 **/
typedef struct {
	union {
		float fn[1];
		uint32_t uintn[1];
	} data;
	uint32_t address;
} floatFlash;

/*
typedef union {

float fn[1];

uint32_t uintn[1];

} float_32t_mask;
*/

static uint32_t g_DMAErrCount = 0;

/*******************
 * Port Assignment *
 *******************/
// Assigns port,pin and peripheral definitions depending on the MCU in use

#ifdef PART_TM4C123GH6PM // EK-TM4C123GXL
	#define TWE_PROCESSING_GPIO_PERIPH 		SYSCTL_PERIPH_GPIOC
	#define TWE_PROCESSING_GPIO_BASE		GPIO_PORTC_BASE
	#define TWE_PROCESSING_PIN				GPIO_PIN_7
#endif

#ifdef PART_TM4C1294NCPDT // EK-TM4C1294XL
	#define TWE_PROCESSING_GPIO_PERIPH 		SYSCTL_PERIPH_GPIOP
	#define TWE_PROCESSING_GPIO_BASE		GPIO_PORTP_BASE
	#define TWE_PROCESSING_PIN				GPIO_PIN_3

#endif

/**************
 * Prototypes *
 **************/
// Flash
extern int32_t twe_initFlash(uint32_t codeStart, uint32_t codeReserveLength,
		                     uint32_t dataStart, uint32_t dataEraseLength);
extern int32_t twe_eraseFlashRange(uint32_t startAddress, uint32_t eraseLength);
extern int32_t twe_protectFlashRange(uint32_t startAddress, uint32_t protectLength, tFlashProtection eProtect);
extern void twe_FLASH_badWriteISR(void);
// FPU
extern void twe_initFPU(void);
extern void twe_initFPUlazy(void);
// UART
extern void twe_initUART0(void);
// SysCtl
extern void twe_initSystem80MHz(void);
// uDMA
extern void twe_initUDMAcontroller(void);
extern void twe_uDMAErrorHandler(void);
// GPIO
extern void twe_initProcessingIndicator(void);
// RGB Extension
extern void twe_RGBInitSolid(uint32_t ui32Enable);
extern void twe_RGBInitSetGreen(void);
// SSI
extern void twe_SSIIntEnableEOT(uint32_t ui32Base);

//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif

#endif /* tw_extension_H_ */
